;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: QP0A.inc
;;   Version: 2.4, Updated on 2004/10/27 at 18:25:09
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for QP0A API's.
;--------------------------------------------------

QP0A_CONTROL_REG_START_BIT:                equ 0x01    ; Control register start bit
QP0A_INT_REG:                              equ 0x0df
QP0A_INT_MASK:                             equ 0x04


;--------------------------------------------------
; Constants for QP0A user defined values
;--------------------------------------------------

QP0A_PERIOD:                               equ 0xff
QP0A_COMPARE_VALUE:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for QP0A
;--------------------------------------------------

QP0A_COUNTER_REG:                      equ 0x48   ; DR0 Counter register
QP0A_PERIOD_REG:                       equ 0x49   ; DR1 Period register
QP0A_COMPARE_REG:                      equ 0x4a   ; DR2 CompareValue register
QP0A_CONTROL_REG:                      equ 0x4b   ; Control register
QP0A_FUNC_REG:                         equ 0x48   ; Function register
QP0A_INPUT_REG:                        equ 0x49   ; Input register
QP0A_OUTPUT_REG:                       equ 0x4a   ; Output register


;--------------------------------------------------
; QP0A Macro 'Functions'
;--------------------------------------------------

   macro QP0A_Start_M
   or    reg[QP0A_CONTROL_REG],  QP0A_CONTROL_REG_START_BIT
   endm

   macro QP0A_Stop_M
   and   reg[QP0A_CONTROL_REG], ~QP0A_CONTROL_REG_START_BIT
   endm

   macro QP0A_EnableInt_M
   M8C_EnableIntMask QP0A_INT_REG, QP0A_INT_MASK
   endm

   macro QP0A_DisableInt_M
   M8C_DisableIntMask QP0A_INT_REG, QP0A_INT_MASK
   endm


; end of file QP0A.inc
